import VehicleInfoPanel from '../VehicleInfoPanel';
import { useState } from 'react';
import { Vehicle } from '../VehicleMap';

// TODO: remove mock functionality
const mockVehicle: Vehicle = {
  id: 1, 
  name: "EV-101", 
  lat: 1.3521, 
  lng: 103.8198, 
  soc: 80, 
  status: "Charging", 
  battery: 60, 
  fleet: false
};

export default function VehicleInfoPanelExample() {
  const [selectedVehicle, setSelectedVehicle] = useState<Vehicle | null>(mockVehicle);

  const handleDispatch = (vehicleId: number) => {
    console.log(`Dispatch signal sent to vehicle ${vehicleId}`);
  };

  return (
    <div className="h-[600px] w-full max-w-md">
      <VehicleInfoPanel 
        selectedVehicle={selectedVehicle}
        onDispatchSignal={handleDispatch}
      />
    </div>
  );
}