import VehicleMap, { Vehicle } from '../VehicleMap';
import { useState } from 'react';

// TODO: remove mock functionality
const mockVehicles: Vehicle[] = [
  { id: 1, name: "EV-101", lat: 1.3521, lng: 103.8198, soc: 80, status: "Idle", battery: 60, fleet: false },
  { id: 2, name: "EV-202", lat: 1.3621, lng: 103.8298, soc: 45, status: "Discharging", battery: 120, fleet: true },
  { id: 3, name: "EV-303", lat: 1.3721, lng: 103.8098, soc: 90, status: "Charging", battery: 75, fleet: false },
  { id: 4, name: "EV-404", lat: 1.3421, lng: 103.8398, soc: 25, status: "Offline", battery: 85, fleet: true },
];

export default function VehicleMapExample() {
  const [selectedVehicle, setSelectedVehicle] = useState<Vehicle | null>(null);

  return (
    <div className="h-[600px] w-full">
      <VehicleMap 
        vehicles={mockVehicles}
        selectedVehicle={selectedVehicle}
        onVehicleSelect={setSelectedVehicle}
      />
    </div>
  );
}