# V2G Platform Design Guidelines

## Design Approach
**Reference-Based Approach**: Drawing inspiration from Tesla's energy dashboard and Uber's fleet management interface, combined with enterprise grid management systems like ABB's energy platforms. This utility-focused application prioritizes data clarity and operational efficiency.

## Core Design Elements

### Color Palette
**Dark Mode Primary** (Professional Grid Management Theme):
- Background: 220 25% 8%
- Surface: 220 20% 12%
- Primary: 200 90% 55% (Electric blue for grid connectivity)
- Success: 140 70% 45% (Charging/available states)
- Warning: 35 85% 60% (Low battery alerts)
- Danger: 0 75% 55% (Grid disconnection/errors)
- Text Primary: 0 0% 95%
- Text Secondary: 220 15% 70%

### Typography
- **Primary**: Inter (Google Fonts) - Clean, technical readability
- **Headings**: Inter 600-700 weight
- **Body**: Inter 400-500 weight
- **Data/Numbers**: Inter 500 weight for emphasis

### Layout System
**Tailwind Spacing Primitives**: 2, 4, 6, 8, 12, 16
- Consistent grid using p-4, m-6, gap-8
- Component spacing: mb-6, mt-8
- Icon/button sizing: h-8, w-12

### Component Library

**Navigation**
- Sidebar with grid management sections
- Tab navigation for Overview/Selection/Economics
- Breadcrumb for deep navigation states

**Map Interface**
- Full-height interactive map (Leaflet/Mapbox)
- Custom vehicle markers with status color coding
- Floating control panels with backdrop blur
- Real-time status indicators

**Data Displays**
- Vehicle cards with battery level progress bars
- Grid status dashboard with live metrics
- Tabular data with alternating row colors
- Status badges (charging/idle/discharging)

**Forms & Controls**
- Dispatch signal controls with confirmation modals
- Filter toggles for fleet vs private vehicles
- Real-time status switches

**Overlays**
- Vehicle detail modals with technical specifications
- Alert notifications for grid events
- Confirmation dialogs for dispatch actions

### Key Design Principles
1. **Grid-First Layout**: Information hierarchy optimized for monitoring multiple vehicles simultaneously
2. **Status-Driven Color**: Vehicle states immediately recognizable through consistent color coding
3. **Real-Time Feedback**: Live data updates without jarring visual changes
4. **Professional Utility**: Clean, technical aesthetic appropriate for grid operators
5. **Operational Clarity**: Critical information (battery levels, grid status) prominently displayed

### Animations
Minimal and purposeful only:
- Smooth map panning/zooming
- Subtle battery level bar fills
- Gentle fade transitions for status changes

This design balances the technical requirements of grid management with modern web application standards, ensuring operators can efficiently monitor and control the V2G network.