import { cn } from "@/lib/utils";

interface MetricDisplayProps {
  label: string;
  value: string | number;
  unit?: string;
  className?: string;
  size?: "sm" | "md" | "lg";
}

export function MetricDisplay({
  label,
  value,
  unit,
  className,
  size = "md",
}: MetricDisplayProps) {
  const sizeClasses = {
    sm: "text-lg",
    md: "text-2xl",
    lg: "text-3xl",
  };

  return (
    <div className={cn("flex flex-col gap-1", className)} data-testid={`metric-${label.toLowerCase().replace(/\s/g, '-')}`}>
      <span className="text-xs uppercase tracking-wide text-muted-foreground">
        {label}
      </span>
      <div className="flex items-baseline gap-1">
        <span className={cn("font-semibold", sizeClasses[size])}>
          {value}
        </span>
        {unit && (
          <span className="text-sm text-muted-foreground">{unit}</span>
        )}
      </div>
    </div>
  );
}
