import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Avatar, AvatarFallback } from "@/components/ui/avatar";
import { Badge } from "@/components/ui/badge";
import { UserPlus, MoreVertical } from "lucide-react";

interface User {
  id: string;
  name: string;
  email: string;
  role: "owner" | "member";
  initials: string;
}

const mockUsers: User[] = [
  { id: "1", name: "John Doe", email: "john@example.com", role: "owner", initials: "JD" },
  { id: "2", name: "Jane Smith", email: "jane@example.com", role: "member", initials: "JS" },
  { id: "3", name: "Mike Johnson", email: "mike@example.com", role: "member", initials: "MJ" },
];

export function UserAccessPanel() {
  return (
    <Card data-testid="panel-user-access">
      <CardHeader>
        <div className="flex items-center justify-between">
          <CardTitle>Authorized Users</CardTitle>
          <Button size="sm" data-testid="button-invite-user">
            <UserPlus className="h-4 w-4 mr-2" />
            Invite
          </Button>
        </div>
      </CardHeader>
      <CardContent className="space-y-3">
        {mockUsers.map((user) => (
          <div
            key={user.id}
            className="flex items-center justify-between p-3 rounded-lg bg-card border border-card-border"
            data-testid={`user-${user.id}`}
          >
            <div className="flex items-center gap-3">
              <Avatar>
                <AvatarFallback>{user.initials}</AvatarFallback>
              </Avatar>
              <div>
                <div className="font-medium">{user.name}</div>
                <div className="text-sm text-muted-foreground">{user.email}</div>
              </div>
            </div>
            <div className="flex items-center gap-2">
              <Badge variant={user.role === "owner" ? "default" : "outline"}>
                {user.role}
              </Badge>
              <Button variant="ghost" size="icon" className="h-8 w-8">
                <MoreVertical className="h-4 w-4" />
              </Button>
            </div>
          </div>
        ))}
      </CardContent>
    </Card>
  );
}
