import { useState } from "react";
import { LiveChargingCard } from "../LiveChargingCard";
import type { ChargingMode } from "../ChargingModeSelector";

export default function LiveChargingCardExample() {
  const [mode, setMode] = useState<ChargingMode>("standard");
  const [status, setStatus] = useState<"charging" | "idle" | "paused">("charging");

  return (
    <div className="p-8 max-w-xl mx-auto">
      <LiveChargingCard
        chargerName="Home Charger"
        status={status}
        currentPower={7.4}
        maxPower={11}
        current={32}
        energyDispensed={15.3}
        duration="2h 15m"
        mode={mode}
        onModeChange={setMode}
        onStart={() => {
          setStatus("charging");
          console.log("Start charging");
        }}
        onStop={() => {
          setStatus("idle");
          console.log("Stop charging");
        }}
        onPause={() => {
          setStatus("paused");
          console.log("Pause charging");
        }}
        onLock={() => console.log("Lock connector")}
      />
    </div>
  );
}
