import { AnalyticsChart } from "@/components/AnalyticsChart";
import { MetricDisplay } from "@/components/MetricDisplay";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";

const monthlyData = [
  { name: "Jan", value: 42 },
  { name: "Feb", value: 48 },
  { name: "Mar", value: 45 },
  { name: "Apr", value: 50 },
  { name: "May", value: 47 },
];

const chargerData = [
  { name: "Orchard Central A1", value: 85 },
  { name: "Marina Bay Sands B1", value: 78 },
  { name: "Punggol Digital District F2", value: 62 },
  { name: "Changi Business Park C1", value: 25 },
];

export default function Analytics() {
  return (
    <div className="space-y-6">
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-4xl font-bold">Analytics</h1>
          <p className="text-muted-foreground mt-2">
            Track usage patterns and optimize charging
          </p>
        </div>
        <Select defaultValue="6months">
          <SelectTrigger className="w-48" data-testid="select-time-range">
            <SelectValue />
          </SelectTrigger>
          <SelectContent>
            <SelectItem value="month">Last Month</SelectItem>
            <SelectItem value="3months">Last 3 Months</SelectItem>
            <SelectItem value="6months">Last 6 Months</SelectItem>
            <SelectItem value="year">Last Year</SelectItem>
          </SelectContent>
        </Select>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-sm font-medium text-muted-foreground">
              Total Power
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="text-3xl font-bold" data-testid="text-total-power">250</div>
            <div className="text-xs text-muted-foreground">kW</div>
            <div className="text-xs text-primary mt-1">+12% from last period</div>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-sm font-medium text-muted-foreground">
              Total Sessions
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="text-3xl font-bold" data-testid="text-total-sessions">5</div>
            <div className="text-xs text-muted-foreground">sessions</div>
            <div className="text-xs text-primary mt-1">+8% from last period</div>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-sm font-medium text-muted-foreground">
              Avg per Session
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="text-3xl font-bold" data-testid="text-avg-per-session">50</div>
            <div className="text-xs text-muted-foreground">kW</div>
            <div className="text-xs text-muted-foreground mt-1">Consistent</div>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-sm font-medium text-muted-foreground">
              Est. Cost Per Session
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="text-3xl font-bold" data-testid="text-est-cost">$50</div>
            <div className="text-xs text-muted-foreground">@ $50/kW</div>
            <div className="text-xs text-primary mt-1">-5% from last period</div>
          </CardContent>
        </Card>
      </div>

      <div className="grid grid-cols-1 xl:grid-cols-2 gap-6">
        <AnalyticsChart title="Monthly Power Consumption (kW)" data={monthlyData} />
        <AnalyticsChart title="Power by Charger (kW)" data={chargerData} />
      </div>

      <Card>
        <CardHeader>
          <CardTitle>Charging Patterns</CardTitle>
        </CardHeader>
        <CardContent>
          <div className="space-y-4">
            <div className="flex items-center justify-between">
              <span className="text-sm text-muted-foreground">Peak Usage Time</span>
              <span className="font-semibold">6:00 PM - 10:00 PM</span>
            </div>
            <div className="flex items-center justify-between">
              <span className="text-sm text-muted-foreground">Most Used Charger</span>
              <span className="font-semibold">Home Driveway (39%)</span>
            </div>
            <div className="flex items-center justify-between">
              <span className="text-sm text-muted-foreground">Preferred Mode</span>
              <span className="font-semibold">Standard (68%)</span>
            </div>
            <div className="flex items-center justify-between">
              <span className="text-sm text-muted-foreground">Avg Session Duration</span>
              <span className="font-semibold" data-testid="text-avg-duration">45 mins</span>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  );
}
