import type { Express } from "express";
import { createServer, type Server } from "http";
import { storage } from "./storage";
import { setupAuth, isAuthenticated } from "./replitAuth";

export async function registerRoutes(app: Express): Promise<Server> {
  // Auth middleware
  await setupAuth(app);

  // Username/password login endpoint
  app.post('/api/auth/login', async (req: any, res) => {
    const { username, password } = req.body;
    
    console.log('[LOGIN] Attempt with username:', username, 'password:', password ? '***' : 'empty');
    
    // Simple credentials check
    if (username === "test" && password === "test") {
      // Create a user if doesn't exist
      const userId = "user-test";
      let user = await storage.getUser(userId);
      
      if (!user) {
        user = await storage.upsertUser({
          id: userId,
          email: "test@flowbank.com",
          firstName: "Test",
          lastName: "User",
        });
      }

      // Create user object matching the structure expected by isAuthenticated
      const authUser = {
        claims: { 
          sub: userId,
          email: "test@flowbank.com",
          first_name: "Test",
          last_name: "User",
          exp: Math.floor(Date.now() / 1000) + (7 * 24 * 60 * 60) // 1 week from now
        },
        access_token: "token",
        refresh_token: null,
        expires_at: Math.floor(Date.now() / 1000) + (7 * 24 * 60 * 60)
      };

      // Use passport.login to properly set up the session
      req.login(authUser, (err: any) => {
        if (err) {
          console.error('[LOGIN] Error during req.login:', err);
          return res.status(500).json({ message: "Failed to login" });
        }
        console.log('[LOGIN] Success! Session created for user:', userId);
        console.log('[LOGIN] Session ID:', req.sessionID);
        return res.json({ success: true });
      });
    } else {
      return res.status(401).json({ message: "Invalid credentials" });
    }
  });

  // Auth routes
  app.get('/api/auth/user', isAuthenticated, async (req: any, res) => {
    try {
      const userId = req.user.claims.sub;
      const user = await storage.getUser(userId);
      res.json(user);
    } catch (error) {
      console.error("Error fetching user:", error);
      res.status(500).json({ message: "Failed to fetch user" });
    }
  });

  // More routes can be added here

  const httpServer = createServer(app);

  return httpServer;
}
